bool	bFogEnabled : FOGENABLED;
float	fFogEnd 	: FOGEND;
float	fFogStart 	: FOGSTART;
float3	vFogColor 	: FOGCOLOR;

float CalcFog(float depth)
{
	return bFogEnabled ? saturate((depth - fFogStart)/(fFogEnd - fFogStart)) : 0.0;
}

void ApplyFog(inout float4 color, float fogAmount)
{
	color.rgb = lerp(color.rgb, vFogColor.rgb, fogAmount);
}
